import 'package:viserpay/core/utils/method.dart';
import 'package:viserpay/core/utils/url_container.dart';
import 'package:viserpay/data/model/global/response_model/response_model.dart';
import 'package:viserpay/data/services/api_service.dart';

class SavingRepo {
  ApiClient apiClient;
  SavingRepo({required this.apiClient});

  Future<ResponseModel> getSavingsData() async {
    final response = await apiClient.request(UrlContainer.savingsData, Method.getMethod, null, passHeader: true);
    return response;
  }

  Future<ResponseModel> getDPSHistory(String page) async {
    final response = await apiClient.request("${UrlContainer.savingsList}?page=$page", Method.getMethod, null, passHeader: true);
    return response;
  }

  Future<ResponseModel> getDPS(String id) async {
    final response = await apiClient.request("${UrlContainer.savingsAccountDetails}/$id", Method.getMethod, null, passHeader: true);
    return response;
  }

  Future<ResponseModel> closeDPS(String id, String pin) async {
    final response = await apiClient.request("${UrlContainer.savingsClosed}/$id", Method.postMethod, {'pin': pin}, passHeader: true);
    return response;
  }

  Future<ResponseModel> getOrganizationList({
    required String tenorId,
    required String intervalId,
    required String installmentAmountId,
  }) async {
    final String url = "${UrlContainer.savingsOrganizationList}?saving_tenure_id=$tenorId&saving_interval_id=$intervalId&installment_amount=$installmentAmountId";
    final response = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return response;
  }

  Future<ResponseModel> submitDpsPlan({
    required String nomineeId,
    required String dpsPlanId,
    required String pin,
    String? otpType,
  }) async {
    final Map<String, dynamic> params = {
      "nominee_id": nomineeId,
      "dps_plan_id": dpsPlanId,
      "pin": pin,
      "otp_type": otpType ?? '',
    };
    final response = await apiClient.request(UrlContainer.savingsAccountCreate, Method.postMethod, params, passHeader: true);

    return response;
  }
}
